/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.MekanismAPI;
import mekanism.api.providers.IRobitSkinProvider;
import mekanism.api.robit.RobitSkin;
import mekanism.client.model.BaseModelCache;
import mekanism.client.render.armor.MekaSuitArmor;
import mekanism.client.render.transmitter.RenderTransmitterBase;
import mekanism.common.Mekanism;
import mekanism.common.tile.qio.TileEntityQIODriveArray;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;

public class MekanismModelCache
extends BaseModelCache {
    public static final MekanismModelCache INSTANCE = new MekanismModelCache();
    private final Set<Runnable> callbacks = new HashSet<Runnable>();
    public final BaseModelCache.OBJModelData MEKASUIT = this.registerOBJ(Mekanism.rl("models/entity/mekasuit.obj"));
    public final BaseModelCache.OBJModelData MEKATOOL_LEFT_HAND = this.registerOBJ(Mekanism.rl("models/entity/mekatool_left.obj"));
    public final BaseModelCache.OBJModelData MEKATOOL_RIGHT_HAND = this.registerOBJ(Mekanism.rl("models/entity/mekatool_right.obj"));
    private final Set<MekaSuitArmor.ModuleOBJModelData> mekaSuitModules = new HashSet<MekaSuitArmor.ModuleOBJModelData>();
    public final Set<MekaSuitArmor.ModuleOBJModelData> MEKASUIT_MODULES = Collections.unmodifiableSet(this.mekaSuitModules);
    public final BaseModelCache.OBJModelData TRANSMITTER_CONTENTS = this.register(RenderTransmitterBase.MODEL_LOCATION, rl -> new BaseModelCache.OBJModelData((ResourceLocation)rl){

        @Override
        protected boolean useDiffuseLighting() {
            return false;
        }
    });
    public final BaseModelCache.JSONModelData LIQUIFIER_BLADE = this.registerJSON(Mekanism.rl("block/liquifier_blade"));
    public final BaseModelCache.JSONModelData PIGMENT_MIXER_SHAFT = this.registerJSON(Mekanism.rl("block/pigment_mixer_shaft"));
    public final BaseModelCache.JSONModelData[] QIO_DRIVES = new BaseModelCache.JSONModelData[TileEntityQIODriveArray.DriveStatus.STATUSES.length];
    private final Map<ResourceLocation, BaseModelCache.JSONModelData> ROBIT_SKINS = new HashMap<ResourceLocation, BaseModelCache.JSONModelData>();
    private BakedModel BASE_ROBIT;

    private MekanismModelCache() {
        for (TileEntityQIODriveArray.DriveStatus status : TileEntityQIODriveArray.DriveStatus.STATUSES) {
            if (status == TileEntityQIODriveArray.DriveStatus.NONE) continue;
            this.QIO_DRIVES[status.ordinal()] = this.registerJSON(status.getModel());
        }
    }

    @Override
    public void setup() {
        HashMap<ResourceLocation, BaseModelCache.JSONModelData> customModels = new HashMap<ResourceLocation, BaseModelCache.JSONModelData>();
        for (RobitSkin skin : MekanismAPI.robitSkinRegistry()) {
            ResourceLocation customModel = skin.getCustomModel();
            if (customModel == null) continue;
            BaseModelCache.JSONModelData model = customModels.computeIfAbsent(customModel, this::registerJSON);
            this.ROBIT_SKINS.put(skin.getRegistryName(), model);
        }
        super.setup();
    }

    @Override
    public void onBake(ModelBakeEvent evt) {
        super.onBake(evt);
        this.callbacks.forEach(Runnable::run);
        this.BASE_ROBIT = MekanismModelCache.getBakedModel(evt, (ResourceLocation)new ModelResourceLocation(Mekanism.rl("robit"), "inventory"));
    }

    public void reloadCallback(Runnable callback) {
        this.callbacks.add(callback);
    }

    @Nullable
    public BakedModel getRobitSkin(@Nonnull IRobitSkinProvider skin) {
        BaseModelCache.JSONModelData data = this.ROBIT_SKINS.get(skin.getRegistryName());
        return data == null ? this.BASE_ROBIT : data.getBakedModel();
    }

    public MekaSuitArmor.ModuleOBJModelData registerMekaSuitModuleModel(ResourceLocation rl) {
        MekaSuitArmor.ModuleOBJModelData data = this.register(rl, MekaSuitArmor.ModuleOBJModelData::new);
        this.mekaSuitModules.add(data);
        return data;
    }
}

